/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using System.IO;
using System.Xml;
using System.Runtime.InteropServices;
using System.Web.Services.Protocols;

public  class SolicitedNotificationByBlockingExample
{
	/// <summary>
	/// Asynchronous getEvent method callback function
	/// </summary>
	void GetEventCallback(IAsyncResult ar)
	{
		// perform an EnfgetEvent call
		object []objs = (object[])((GCE)ar.AsyncState).EndgetEvent(ar);
		XmlElement elem = (XmlElement)objs[0];

		Console.WriteLine("==>GetEvent response received.Results :");
		// check separately created,updated and removed items
		DisplayNotification(elem,"CfgCreate","Created");
		DisplayNotification(elem,"CfgUpdate","Updated");
		DisplayNotification(elem,"CfgRemove","Removed");
	}

	/// <summary>
	/// Displays results of the notification
	/// </summary>
	void DisplayNotification(XmlElement cfgData,string elementName,string textStr)
	{
		XmlElement operElem = cfgData[elementName];
		// display only if there's something to display
		if (operElem != null && operElem.ChildNodes.Count > 0)
		{
			Console.WriteLine(" ===>" + textStr + ":");
			foreach (XmlElement elem in operElem.ChildNodes)
				Console.WriteLine("  Object [{0}], DBID [{1}], name [{2}]",
					elem.Name,elem.GetAttribute("DBID"),elem.GetAttribute("name"));
		}
	}

	public void execute(String targetHost)
	{
		try 
		{
			RegisterToConfigurationServiceExample registerExample = new RegisterToConfigurationServiceExample();
			registerExample.execute(targetHost);

			GCE cfgService = registerExample.cfgService;

			// get Configuration Service version
			Console.WriteLine("==>Configuration Service version is ..." + 
				cfgService.getVersion());

			// subscribe on notifications on Agents
			Console.WriteLine("==>Subscription on notifications completed ..." + 
				cfgService.subscribe("CfgAgent","",""));

			// initialize asynchronous getEvent call
			Console.WriteLine("==>Initiate notification request");
			IAsyncResult asyncResult = cfgService.BegingetEvent(new AsyncCallback(GetEventCallback),cfgService);

			// wait until response will come
			while (asyncResult.AsyncWaitHandle.WaitOne(50,true) == false)
			{
				// do something ...
			}

			Console.WriteLine("done");
			cfgService.unregister();
		}
		catch (Exception e)
		{
			Console.WriteLine(e.Message);
		}
	}
}

